#include "wx/object.h"
#include "wx/listctrl.h"

enum {
	BOLT_ACCESS_DISABLED=0,
		BOLT_ACCESS_GUEST,
		BOLT_ACCESS_CASHIER,
		BOLT_ACCESS_SUPERVISOR,
		BOLT_ACCESS_MANAGER,
		BOLT_ACCESS_OWNER,
		BOLT_ACCESS_TECHNICIAN };

class BOLTUser 
{
public:
	int accessLevel;
	bool LoggedIn;
	bool useClassicMode;
	wxFont fFont;
	wxString font;
	RECORD_ID id;
	RECORD_ID registerId;
	wxString name;
	BOLTUser(RECORD_ID id,wxString& name) {
		this->id=id;
		this->name=name;
		this->font="";
		this->registerId=0;
		accessLevel=BOLT_ACCESS_DISABLED;
		useClassicMode=false;
	};
	~BOLTUser()
	{};
virtual void Dump(ostream& stream) 
	{	stream << "Dump : BOLTUser"; }

};

class BOLTLogin : public wxDialog
{
//DECLARE_DYNAMIC_CLASS(BOLTLogin)
public:
	BOLTLogin(BOLTdb* db,wxWindow *parent);
	BOLTUser *GetUser();
	~BOLTLogin();
	void OnCancel(wxCommandEvent& evt);
	void OnOk(wxCommandEvent& evt);
	void OnChangeDB(wxCommandEvent& evt);
	void OnQuit(wxCommandEvent& evt);
virtual void Dump(ostream& stream) 
	{	stream << "Dump : BOLTLogin"; }

private:
	BOLTdb *db;
	wxTextCtrl *cUser,*cPass;
	wxButton *bOk,*bCancel,*bChangeDB,*bQuit;
	DECLARE_EVENT_TABLE()
};

class BOLTUserManager : public wxDialog
{
//DECLARE_DYNAMIC_CLASS(BOLTUserManager)
public:
	void OnAccess(wxCommandEvent & evt);
	wxChoice * cAccess;
	wxArrayInt aId;
	wxCheckBox * cbClassicMode;
	void OnFont(wxCommandEvent & event);
	void OnDelete(wxCommandEvent &event);
	void FillUsers();
	void OnText(wxCommandEvent & event);
	BOLTUserManager(wxWindow *parent,BOLTdb *db);
	void OnNew(wxCommandEvent& event);
	void OnUpdate(wxCommandEvent& event);
	void OnChoose(wxCommandEvent& event);
	void OnDone(wxCommandEvent& event);
virtual void Dump(ostream& stream) 
	{	stream << "Dump : BOLTUserManager"; }

private:
	void UpdateUserList();
	BOLTdb *db;
	wxTextCtrl *tUser,*tPass,*tInit,*tName;
	wxButton  *bNew,*bUpdate,*bDelete,*bDone;
	wxListBox *lUsers;
	RECORD_ID tEmployeeId;
	DECLARE_EVENT_TABLE();
protected:
	wxString sFont;
};